
/**
 * class Sudoku - Beschrijft een spelletje Sudoku
 *
 * @author Dominiek Vandewalle
 * @version 2017-11-08
 */
public class Sudoku
{
    private int volgnummer;
    private int niveau;
    
    /**
     * Constructor voor objecten van de klasse Sudoku.
     * @param   volgnummer  Het volgnummer van de sudoku.
     * @param   niveau      Het niveau van de sudoku.
     */
    public Sudoku(int volgnummer, int niveau)
    {
        this.volgnummer = volgnummer;
        this.niveau = niveau;
    }
    
    /**
     * Geeft het volgnummer van de sudoku terug.
     * @return  Het volgnummer van de sudoku.
     */
    public int getVolgnummer()
    {
        return volgnummer;
    }
    
    /**
     * Geeft het niveau van de sudoku terug.
     * @return  Het niveau van de sudoku.
     */
    public int getNiveau()
    {
        return niveau;
    }
    
    /**
     * Controleert of het volgnummer geldig is.
     * @return  True indien het volgnummer geldig is, anders false.
     */
    public boolean isGeldigVolgnummer()
    {
        return volgnummer > 0;
    }
    
    /**
     * Controleert of het niveau van de sudoku geldig is.
     * Geldige sudoku's hebben een niveau gelijk aan 1, 2 of 3.
     * @return  True indien het niveau geldig is, anders false.
     */
    public boolean isGeldigNiveau()
    {
        return niveau >=1 && niveau <= 3;
    }
    
    /**
     * Controleert of de sudoku geldig is. Een sudoku is geldig wanneer:
     * - het volgnummer geldig is.
     * - het niveau geldig is.
     * @return  True indien de sudoku geldige is, anders false.
     */
    public boolean isGeldigeSudoku()
    {
        return isGeldigVolgnummer() && isGeldigNiveau();
    }
    
    /**
     * Toont informatie over de sudoku in het terminalvenster.
     */
    public void print()
    {
            System.out.println("Niveau " + niveau + " --> Sudoku " + volgnummer); 
    }
}
